<?php
// bot_functions.php

$BOT_TOKEN = '8085070263:AAF-9_aT_O5yM-OhMCeCKejmDytlmx_zxX0';
$API_URL = "https://api.telegram.org/bot$BOT_TOKEN/";
$ADMIN_ID = '7262498815'; // Admin Telegram user ID

function handleUpdate($update) {
    if (isset($update['message'])) {
        handleMessage($update['message']);
    } elseif (isset($update['callback_query'])) {
        handleCallback($update['callback_query']);
    }
}

function handleMessage($message) {
    global $API_URL, $ADMIN_ID;

    $chat_id = $message['chat']['id'];
    $user_id = $message['from']['id'];
    $username = $message['from']['username'] ?? 'NoUsername';
    $text = trim($message['text'] ?? '');

    // Save user ID if new
    $is_new_user = saveUserId($user_id);

    if ($text == "/start") {
        $welcome = "👋 Welcome to *MIEFAUCET*\n\nEarn free crypto, complete tasks, claim faucet, do PTC, and join our community!";

        $keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => "💰 EARN", 'web_app' => ['url' => "https://miefaucet.xyz"]],
                    ['text' => "👥 JOIN COMMUNITY", 'url' => "https://t.me/miefaucet"]
                ]
            ]
        ];

        // Admin-only stats button
        if ($user_id == $ADMIN_ID) {
            $keyboard['inline_keyboard'][] = [
                ['text' => "📊 STATS", 'callback_data' => "show_stats"]
            ];
        }

        sendMessage($chat_id, $welcome, $keyboard);

        // Notify admin about new user
        if ($is_new_user && $user_id != $ADMIN_ID) {
            $note = "📥 New user started the bot:\n👤 @$username\n🆔 `$user_id`";
            sendMessage($ADMIN_ID, $note);
        }
    }

    // Broadcast feature
    if ($text == "/admin" && $user_id == $ADMIN_ID) {
        file_put_contents("broadcast_mode.txt", "on");
        sendMessage($chat_id, "📢 Send the message you want to broadcast:");
        return;
    }

    // Broadcast message
    if ($user_id == $ADMIN_ID && file_exists("broadcast_mode.txt")) {
        unlink("broadcast_mode.txt");
        broadcastMessage($text);
        sendMessage($chat_id, "✅ Broadcast sent to all users.");
        return;
    }
}

function handleCallback($callback) {
    global $API_URL, $ADMIN_ID;

    $data = $callback['data'];
    $chat_id = $callback['message']['chat']['id'];
    $user_id = $callback['from']['id'];

    if ($data == "show_stats" && $user_id == $ADMIN_ID) {
        $user_count = file_exists("user_list.txt") ? count(file("user_list.txt", FILE_IGNORE_NEW_LINES)) : 0;
        $response = "📈 *MIEFAUCET Stats*\n\n👥 Total Users: `$user_count`";
        answerCallback($callback['id'], "Showing stats...");
        sendMessage($chat_id, $response);
    }
}

function sendMessage($chat_id, $text, $keyboard = null) {
    global $API_URL;

    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'Markdown'
    ];

    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }

    file_get_contents($API_URL . "sendMessage?" . http_build_query($data));
}

function answerCallback($callback_id, $text) {
    global $API_URL;

    $data = [
        'callback_query_id' => $callback_id,
        'text' => $text,
        'show_alert' => false
    ];

    file_get_contents($API_URL . "answerCallbackQuery?" . http_build_query($data));
}

function saveUserId($user_id) {
    $file = "user_list.txt";
    $users = file_exists($file) ? file($file, FILE_IGNORE_NEW_LINES) : [];

    if (!in_array($user_id, $users)) {
        file_put_contents($file, $user_id . PHP_EOL, FILE_APPEND);
        return true; // New user
    }

    return false; // Existing user
}

function broadcastMessage($text) {
    global $API_URL;

    $file = "user_list.txt";
    if (!file_exists($file)) return;

    $users = file($file, FILE_IGNORE_NEW_LINES);
    foreach ($users as $user_id) {
        $data = [
            'chat_id' => $user_id,
            'text' => "📢 $text"
        ];
        file_get_contents($API_URL . "sendMessage?" . http_build_query($data));
    }
}
